<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateStoryRequest;
use App\Http\Requests\UpdateStoryRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\Story;
use Illuminate\Http\Request;
use Flash;
use Response;

class StoryController extends AppBaseController
{
    /**
     * Display a listing of the Story.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        /** @var Story $stories */
        $stories = Story::withSearch()->latest()->paginate(10);

        return view('admin.stories.index')
            ->with('stories', $stories);
    }

    /**
     * Show the form for creating a new Story.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.stories.create');
    }

    /**
     * Store a newly created Story in storage.
     *
     * @param CreateStoryRequest $request
     *
     * @return Response
     */
    public function store(CreateStoryRequest $request, Story $story)
    {
        $input = $request->all();
        $input['image'] = $story->uploadFile($field = 'image', $save_title=$request->name, $path=null);
        $input['video_type'] = $story->uploadFile($field = 'video_type', $save_title=$request->name, $path=$story->upload_video_path);
        /** @var Story $story */
        $story = Story::create($input);

        Flash::success('Story saved successfully.');

        return redirect(route('admin.stories.index'));
    }

    /**
     * Display the specified Story.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var Story $story */
        $story = Story::find($id);

        if (empty($story)) {
            Flash::error('Story not found');

            return redirect(route('admin.stories.index'));
        }

        return view('admin.stories.show')->with('story', $story);
    }

    /**
     * Show the form for editing the specified Story.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var Story $story */
        $story = Story::find($id);

        if (empty($story)) {
            Flash::error('Story not found');

            return redirect(route('admin.stories.index'));
        }

        return view('admin.stories.edit')->with('story', $story);
    }

    /**
     * Update the specified Story in storage.
     *
     * @param int $id
     * @param UpdateStoryRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateStoryRequest $request)
    {
        /** @var Story $story */
        $story = Story::find($id);

        if (empty($story)) {
            Flash::error('Story not found');

            return redirect(route('admin.stories.index'));
        }

        $story->fill($request->all());
        $story->image = $story->delete_existing_and_upload_file($field = 'image', $save_title=$request->name, $path=null);

        $story->video_src = $story->delete_existing_and_upload_file($field = 'video_src', $save_title=$request->name, $path=$story->upload_video_path);

        $story->save();

        Flash::success('Story updated successfully.');

        return redirect(route('admin.stories.index'));
    }

    /**
     * Remove the specified Story from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var Story $story */
        $story = Story::find($id);

        if (empty($story)) {
            Flash::error('Story not found');

            return redirect(route('admin.stories.index'));
        }
        
        $story->deleteImage('image');
        $story->delete();

        Flash::success('Story deleted successfully.');

        return redirect(route('admin.stories.index'));
    }
}
