<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreatePublicationRequest;
use App\Http\Requests\UpdatePublicationRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\Publication;
use Illuminate\Http\Request;
use Flash;
use Response;

class PublicationController extends AppBaseController
{
    /**
     * Display a listing of the Publication.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        /** @var Publication $publications */
        $publications = Publication::withSearch()->latest()->paginate(10);

        return view('admin.publications.index')
            ->with('publications', $publications);
    }

    /**
     * Show the form for creating a new Publication.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.publications.create');
    }

    /**
     * Store a newly created Publication in storage.
     *
     * @param CreatePublicationRequest $request
     *
     * @return Response
     */
    public function store(CreatePublicationRequest $request, Publication $publication)
    {
        $input = $request->all();

        $input['image'] = $publication->uploadFile($field = 'image', $save_title=$request->title, $path=null);
        $input['attachment'] = $publication->uploadFile($field = 'attachment', $save_title=$request->title, $path=null);

        /** @var Publication $publication */
        $publication = Publication::create($input);

        Flash::success('Publication saved successfully.');

        return redirect(route('admin.publications.index'));
    }

    /**
     * Display the specified Publication.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var Publication $publication */
        $publication = Publication::find($id);

        if (empty($publication)) {
            Flash::error('Publication not found');

            return redirect(route('admin.publications.index'));
        }

        return view('admin.publications.show')->with('publication', $publication);
    }

    /**
     * Show the form for editing the specified Publication.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var Publication $publication */
        $publication = Publication::find($id);

        if (empty($publication)) {
            Flash::error('Publication not found');

            return redirect(route('admin.publications.index'));
        }

        return view('admin.publications.edit')->with('publication', $publication);
    }

    /**
     * Update the specified Publication in storage.
     *
     * @param int $id
     * @param UpdatePublicationRequest $request
     *
     * @return Response
     */
    public function update($id, UpdatePublicationRequest $request)
    {
        /** @var Publication $publication */
        $publication = Publication::find($id);

        if (empty($publication)) {
            Flash::error('Publication not found');

            return redirect(route('admin.publications.index'));
        }

        $publication->fill($request->all());
        $publication->image = $publication->delete_existing_and_upload_file($field = 'image', $save_title=$request->title, $path=null);
        $publication->attachment = $publication->delete_existing_and_upload_file($field = 'attachment', $save_title=$request->title, $path=null);
        $publication->save();

        Flash::success('Publication updated successfully.');

        return redirect(route('admin.publications.index'));
    }

    /**
     * Remove the specified Publication from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var Publication $publication */
        $publication = Publication::find($id);

        if (empty($publication)) {
            Flash::error('Publication not found');

            return redirect(route('admin.publications.index'));
        }

        $publication->delete();

        Flash::success('Publication deleted successfully.');

        return redirect(route('admin.publications.index'));
    }
}
