<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateNewsletterRequest;
use App\Http\Requests\UpdateNewsletterRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\Newsletter;
use Illuminate\Http\Request;
use Flash;
use Response;

class NewsletterController extends AppBaseController
{
    /**
     * Display a listing of the Newsletter.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        /** @var Newsletter $newsletters */
        $newsletters = Newsletter::withSearch()->latest()->paginate(10);

        return view('admin.newsletters.index')
            ->with('newsletters', $newsletters);
    }

    /**
     * Show the form for creating a new Newsletter.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.newsletters.create');
    }

    /**
     * Store a newly created Newsletter in storage.
     *
     * @param CreateNewsletterRequest $request
     *
     * @return Response
     */
    public function store(CreateNewsletterRequest $request)
    {
        $input = $request->all();

        /** @var Newsletter $newsletter */
        $newsletter = Newsletter::create($input);

        Flash::success('Newsletter saved successfully.');

        return redirect(route('admin.newsletters.index'));
    }

    /**
     * Display the specified Newsletter.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var Newsletter $newsletter */
        $newsletter = Newsletter::find($id);

        if (empty($newsletter)) {
            Flash::error('Newsletter not found');

            return redirect(route('admin.newsletters.index'));
        }

        return view('admin.newsletters.show')->with('newsletter', $newsletter);
    }

    /**
     * Show the form for editing the specified Newsletter.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var Newsletter $newsletter */
        $newsletter = Newsletter::find($id);

        if (empty($newsletter)) {
            Flash::error('Newsletter not found');

            return redirect(route('admin.newsletters.index'));
        }

        return view('admin.newsletters.edit')->with('newsletter', $newsletter);
    }

    /**
     * Update the specified Newsletter in storage.
     *
     * @param int $id
     * @param UpdateNewsletterRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateNewsletterRequest $request)
    {
        /** @var Newsletter $newsletter */
        $newsletter = Newsletter::find($id);

        if (empty($newsletter)) {
            Flash::error('Newsletter not found');

            return redirect(route('admin.newsletters.index'));
        }

        $newsletter->fill($request->all());
        $newsletter->save();

        Flash::success('Newsletter updated successfully.');

        return redirect(route('admin.newsletters.index'));
    }

    /**
     * Remove the specified Newsletter from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var Newsletter $newsletter */
        $newsletter = Newsletter::find($id);

        if (empty($newsletter)) {
            Flash::error('Newsletter not found');

            return redirect(route('admin.newsletters.index'));
        }

        $newsletter->delete();

        Flash::success('Newsletter deleted successfully.');

        return redirect(route('admin.newsletters.index'));
    }
}
