<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateMemberCategoryRequest;
use App\Http\Requests\UpdateMemberCategoryRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\MemberCategory;
use Illuminate\Http\Request;
use Flash;
use Response;

class MemberCategoryController extends AppBaseController
{
    /**
     * Display a listing of the MemberCategory.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        /** @var MemberCategory $memberCategories */
        $memberCategories = MemberCategory::withSearch()->latest()->paginate(10);

        return view('admin.member_categories.index')
            ->with('memberCategories', $memberCategories);
    }

    /**
     * Show the form for creating a new MemberCategory.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.member_categories.create');
    }

    /**
     * Store a newly created MemberCategory in storage.
     *
     * @param CreateMemberCategoryRequest $request
     *
     * @return Response
     */
    public function store(CreateMemberCategoryRequest $request)
    {
        $input = $request->all();

        /** @var MemberCategory $memberCategory */
        $memberCategory = MemberCategory::create($input);

        Flash::success('Member Category saved successfully.');

        return redirect(route('admin.memberCategories.index'));
    }

    /**
     * Display the specified MemberCategory.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var MemberCategory $memberCategory */
        $memberCategory = MemberCategory::find($id);

        if (empty($memberCategory)) {
            Flash::error('Member Category not found');

            return redirect(route('admin.memberCategories.index'));
        }

        return view('admin.member_categories.show')->with('memberCategory', $memberCategory);
    }

    /**
     * Show the form for editing the specified MemberCategory.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var MemberCategory $memberCategory */
        $memberCategory = MemberCategory::find($id);

        if (empty($memberCategory)) {
            Flash::error('Member Category not found');

            return redirect(route('admin.memberCategories.index'));
        }

        return view('admin.member_categories.edit')->with('memberCategory', $memberCategory);
    }

    /**
     * Update the specified MemberCategory in storage.
     *
     * @param int $id
     * @param UpdateMemberCategoryRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateMemberCategoryRequest $request)
    {
        /** @var MemberCategory $memberCategory */
        $memberCategory = MemberCategory::find($id);

        if (empty($memberCategory)) {
            Flash::error('Member Category not found');

            return redirect(route('admin.memberCategories.index'));
        }

        $memberCategory->fill($request->all());
        $memberCategory->save();

        Flash::success('Member Category updated successfully.');

        return redirect(route('admin.memberCategories.index'));
    }

    /**
     * Remove the specified MemberCategory from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var MemberCategory $memberCategory */
        $memberCategory = MemberCategory::find($id);

        if (empty($memberCategory)) {
            Flash::error('Member Category not found');

            return redirect(route('admin.memberCategories.index'));
        }

        $memberCategory->delete();

        Flash::success('Member Category deleted successfully.');

        return redirect(route('admin.memberCategories.index'));
    }
}
