<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateEventRequest;
use App\Http\Requests\UpdateEventRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\Event;
use Illuminate\Http\Request;
use Flash;
use Response;

class EventController extends AppBaseController
{
    /**
     * Display a listing of the Event.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        /** @var Event $events */
        $events = Event::withSearch()->latest()->paginate(10);

        return view('admin.events.index')
            ->with('events', $events);
    }

    /**
     * Show the form for creating a new Event.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.events.create');
    }

    /**
     * Store a newly created Event in storage.
     *
     * @param CreateEventRequest $request
     *
     * @return Response
     */
    public function store(CreateEventRequest $request, Event $event)
    {
        $input = $request->all();
        $input['image'] = $event->uploadFile($field = 'image', $save_title=$request->title, $path=null);

        /** @var Event $event */
        $event = Event::create($input);

        Flash::success('Event saved successfully.');

        return redirect(route('admin.events.index'));
    }

    /**
     * Display the specified Event.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var Event $event */
        $event = Event::find($id);

        if (empty($event)) {
            Flash::error('Event not found');

            return redirect(route('admin.events.index'));
        }

        return view('admin.events.show')->with('event', $event);
    }

    /**
     * Show the form for editing the specified Event.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var Event $event */
        $event = Event::find($id);

        if (empty($event)) {
            Flash::error('Event not found');

            return redirect(route('admin.events.index'));
        }

        return view('admin.events.edit')->with('event', $event);
    }

    /**
     * Update the specified Event in storage.
     *
     * @param int $id
     * @param UpdateEventRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateEventRequest $request)
    {
        /** @var Event $event */
        $event = Event::find($id);

        if (empty($event)) {
            Flash::error('Event not found');

            return redirect(route('admin.events.index'));
        }

        $event->fill($request->all());
        
        $event->image = $event->delete_existing_and_upload_file($field = 'image', $save_title=$request->title, $path=null);
        $event->save();

        Flash::success('Event updated successfully.');

        return redirect(route('admin.events.index'));
    }

    /**
     * Remove the specified Event from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var Event $event */
        $event = Event::find($id);

        if (empty($event)) {
            Flash::error('Event not found');

            return redirect(route('admin.events.index'));
        }
        
        $event->deleteImage('image');
        $event->delete();

        Flash::success('Event deleted successfully.');

        return redirect(route('admin.events.index'));
    }
}
