<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Student;
use Illuminate\Http\Request;
use Image;
use DB;
use App\Http\Resources\StudentResource;


use Illuminate\Support\Facades\Hash;


class StudentController extends Controller
{
    public function get_students(){


        $students = new \App\Models\Student;

        if(request('city')){
            $students = $students->where( 'workplace', 'like', '%' . request('city') . '%');
        }

        if(request('univercity')){
            $students = $students->where( 'nuc', 'like', '%' . request('univercity') . '%');
        }

        if(request('name')){
            $students = $students->where( 'name', 'like', '%' . request('name') . '%');
        }

        if(request('degree')){
            $students = $students->where( 'degree', 'like', '%' . request('degree') . '%');
        }

        if(request('major')){
            $students = $students->where( 'major', 'like', '%' . request('major') . '%');
        }

        // if(request('gyear')){
        //     $students = $students->where( 'gyear', 'like', '%' . request('gyear') . '%');
        // }

        $students = $students->active()->latest()->paginate(10);
        return StudentResource::collection($students);
    }

    public function store(Request $request){

        // return response()->json($request->all());

        $request->validate([

            // 'username' => 'required|unique:students,username',
            'email' => 'required|unique:students,email',

            'password' => 'required',
            'name' => 'required',
            'degree' => 'required',
            'major' => 'required',
            'nuc' => 'required',
            'gyear' => 'required',

            'g_photo'  => 'required|mimes:jpg,pdf,doc|max:5120',
            'p_photo'  => 'required|mimes:jpeg,png,pdf,jpg|max:2048',

            'award_status' => 'required',
            'occupation' => 'required',
            'workplace' => 'required',
            'address' => 'required',
            'phone' => 'required',
            // 'wechat' => 'required',
            'gender' => 'required',
            // 'message' => 'required',


            'award_list.*.awname' => $request->award_status ? 'required' : '',
            'award_list.*.awtime' => $request->award_status ? 'required' : '',
            'award_list.*.awcertificate'    => $request->award_status ? 'required|mimes:jpg,pdf,doc|max:5120': '',
       ],
       [
       ]);



       try {
            DB::beginTransaction();

            $student = new Student;
            // $student->username = $request->username;
            $student->password = bcrypt($request->password);
            $student->name = $request->name;
            $student->degree = $request->degree;
            $student->major = $request->major;
            $student->nuc = $request->nuc;
            $student->gyear = $request->gyear;

            $student->p_photo  =  $student->uploadFileVue('p_photo', $student->name . '_profile', 'uploads/profile_photo/');
            $student->g_photo  =  $student->uploadFileVue('g_photo', $student->name . '_graduation', 'uploads/graduation_photo/');

            // // IMAGE GRADUTAION PHOTO g_photo
            // $has_graduation_file = request('g_photo');

            // if($has_graduation_file){
            //     $extension = $has_graduation_file->getClientOriginalExtension(); // getting image extension
            //     $filename = remove_space_dots_replace_underscore($student->name) . '_' . time() . mt_rand(1000, 9999) . '.'.$extension;

            //     Image::make($request->g_photo)->save(public_path('uploads/graduation_photo/').$filename);

            //     $student->g_photo  =  $filename;
            // }


            // // IMAGE PROFILE PHOTO
            // $has_profile_photo = request('p_photo');

            // if($has_profile_photo){
            //     $extension = $has_profile_photo->getClientOriginalExtension(); // getting image extension
            //     $filename =  remove_space_dots_replace_underscore($student->name) . '_profile_' . time() . mt_rand(1000, 9999) . '.'.$extension;

            //     Image::make($request->p_photo)->save(public_path('uploads/profile_photo/').$filename);

            //     $student->p_photo  =  $filename;
            // }


            // $student->g_photo = $student->uploadFile($field = 'g_photo', $save_title=$request->name, $path=null);

            $student->award_status = $request->award_status;
            $student->occupation = $request->occupation;
            $student->workplace = $request->workplace;
            $student->address = $request->address;
            $student->email = $request->email;
            $student->phone = $request->phone;
            $student->wechat = $request->wechat;
            $student->message = $request->message;

            $student->gender = $request->gender; // new

            $student->user_type = $request->user_type;
            $student->status = 0;

            $student->save();


            if($request->award_status){
                foreach ($request->award_list as $index => $award) {
                    // return $student->uploadFileVueRequestMethod(request(award_list[0][awcertificate]), $student->name . '_awcertificate', 'uploads/awcertificate/');

                    \App\Models\StudentAward::create([
                        'student_id' => $student->id,
                        'awname' => $award['awname'],
                        'awtime' => date("Y-m-d H:i:s",strtotime($award['awtime'])),
                        'awcertificate' => $student->uploadFileVue(request('award_list')[$index]['awcertificate'], $student->name . '_awcertificate', 'uploads/awcertificate/', true),
                        'status' => 1,
                    ]);
                }
            }

            DB::commit();
            \App\Models\Email::new_alumunis_profile($student);
            // DB::rollBack();

            return response()->json(['status' => 'success', 'message' => 'We have got your registration request successfully']);
       }
       catch( \Execption $e ) {
            DB::rollBack();

            return response()->json(['status' => 'error', 'message' => 'Something wrong']);
       }


    }
}
