<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Http\Resources\EventResource;

use App\Http\Resources\JobSubscriberResource;
use App\Http\Resources\EventSubscriberResource;
use App\Http\Resources\StudentAwardResource;
use App\Http\Resources\JobResource;
use App\Models\Job;

use App\Models\StudentAward as Award;

use Image;
use DB;

class DashboardController extends Controller
{
    public function my_events(){
    	$events = \App\Models\EventSubscriber::where('student_id', auth('api')->user()->id)->active()->paginate(10);
        return EventSubscriberResource::collection($events);
	}

	public function my_posted_jobs(){
		$jobs = \App\Models\Job::where('created_by', auth('api')->user()->id)->paginate(10);
        return JobResource::collection($jobs);
	}

	public function my_applied_jobs(){
		$jobs = \App\Models\JobSubscriber::where('student_id', auth('api')->user()->id)->paginate(10);
        return JobSubscriberResource::collection($jobs);
	}


	public function post_job(Request $request, Job $job){

        $request->validate([

            'title' => 'required',
            'salary' => 'required',
            'salary_negotialble' => 'required',
            'position' => 'required',
            'description' => 'required',
            'description_additional' => 'required',
            'dead_line' => 'required',
            'cmp_name' => 'required',
            'cmp_website' => 'required',
            'cmp_image' => 'required|image|max:2048',
            'cmp_description' => 'required',
            'cmp_location' => 'required',
            'completed' => 'required',
           
       ],
       [
       ]);



       try {
            DB::beginTransaction();

            $job = new Job;

            $job->title = $request->title;
            $job->salary = $request->salary;
            $job->salary_negotialble = $request->salary_negotialble;
            $job->position = $request->position;
            $job->description = $request->description;
            $job->description_additional = $request->description_additional;
            $job->dead_line = date("Y-m-d H:i:s",strtotime($request->dead_line));
            $job->cmp_name = $request->cmp_name;
            $job->cmp_website = $request->cmp_website;
            $job->cmp_image = $request->cmp_image;
            $job->cmp_description = $request->cmp_description;
            $job->cmp_location = $request->cmp_location;

            $job->created_by = auth('api')->user()->id;

            // IMAGE GRADUTAION PHOTO cmp_image
            $has_company_logo = request()->hasfile('cmp_image');

            if($has_company_logo){
                $company_logo = request('cmp_image');
                $extension = $company_logo->getClientOriginalExtension(); // getting image extension
                $filename = remove_space_dots_replace_underscore($job->name) . '_' . time() . mt_rand(1000, 9999) . '.'.$extension;

                Image::make($request->cmp_image)->save(public_path('uploads/jobs/').$filename);

                $job->cmp_image  =  $filename;
            }

            // $job->status = 1;
            $job->save();

            DB::commit();
            // DB::rollBack();

            return response()->json(['status' => 'success', 'message' => 'Your job post created successfully']);
       }
       catch( \Execption $e ) {
            DB::rollBack();
            return response()->json(['status' => 'error', 'message' => 'Something wrong']);
       }
	}


    public function update_job($id, Request $request, Job $job){

        $request->validate([

            'title' => 'required',
            'salary' => 'required',
            'salary_negotialble' => 'required',
            'position' => 'required',
            'description' => 'required',
            'description_additional' => 'required',
            'dead_line' => 'required',
            'cmp_name' => 'required',
            'cmp_website' => 'required',
            'cmp_image' => 'max:2048',
            'cmp_description' => 'required',
            'cmp_location' => 'required',
            'completed' => 'required',
       ],
       [
       ]);



       try {
            DB::beginTransaction();

            $job = \App\Models\Job::find($id);

            $job->fill($request->all());
            // $job->dead_line = $request->dead_line ? date("Y-m-d H:i:s",strtotime($request->dead_line)) : $job->dead_line;
            $job->created_by = auth('api')->user()->id;

            // IMAGE GRADUTAION PHOTO awcertificate
            $has_company_logo = request()->hasfile('awcertificate');

            if($has_company_logo){
                $company_logo = request('awcertificate');
                $extension = $company_logo->getClientOriginalExtension(); // getting image extension
                $filename = remove_space_dots_replace_underscore($job->name) . '_' . time() . mt_rand(1000, 9999) . '.'.$extension;

                Image::make($request->awcertificate)->save(public_path('uploads/jobs/').$filename);

                $job->awcertificate  =  $filename;
            }
            

            $job->save();

            DB::commit();
            // DB::rollBack();

            return response()->json(['status' => 'success', 'message' => 'Job Updated successfully']);
       }
       catch( \Execption $e ) {
            DB::rollBack();

            return response()->json(['status' => 'error', 'message' => 'Something wrong']);
       }
    }


    public function my_awards(){
        $StudentAward = \App\Models\StudentAward::where('student_id', auth('api')->user()->id)->paginate(10);
        return StudentAwardResource::collection($StudentAward);
    }

    public function award_show($id){
        $award = \App\Models\StudentAward::find($id);
        return new StudentAwardResource($award);
    }

    public function post_award(Request $request, Award $award){

        $request->validate([

            'awname' => 'required',
            'awtime' => 'required',
            'awcertificate' => 'required|mimes:jpeg,png,pdf|max:2048',

            
           
       ],
       [
       ]);

       try {
            DB::beginTransaction();

            $award = new Award;

            $award->awname = $request->awname;
            $award->awtime = $request->awtime;
            $award->student_id = auth('api')->user()->id;

            // IMAGE GRADUTAION PHOTO cmp_image
            $has_certific_logo = request()->hasfile('awcertificate');

            if($has_certific_logo){
                $certific_logo = request('awcertificate');
                $extension = $certific_logo->getClientOriginalExtension(); // getting image extension
                $filename = remove_space_dots_replace_underscore($award->name) . '_' . time() . mt_rand(1000, 9999) . '.'.$extension;

                Image::make($request->awcertificate)->save(public_path('uploads/awcertificate/').$filename);

                $award->awcertificate  =  $filename;
            }

            // $award->status = 1;
            $award->save();

            DB::commit();
            // DB::rollBack();

            return response()->json(['status' => 'success', 'message' => 'Your award post created successfully']);
       }
       catch( \Execption $e ) {
            DB::rollBack();
            return response()->json(['status' => 'error', 'message' => 'Something wrong'], 422);
       }
    }


    public function update_award($id, Request $request, Award $award){

        $request->validate([
            'awname' => 'required',
            'awtime' => 'required',
            'awcertificate' => request()->hasfile('awcertificate') ? 'mimes:jpeg,png,pdf|max:2048' : '',
       ],
       [
       ]);



       try {
            DB::beginTransaction();

            $award = Award::find($id);

            $award->fill($request->all());
            // $award->dead_line = $request->dead_line ? date("Y-m-d H:i:s",strtotime($request->dead_line)) : $award->dead_line;
            $award->student_id = auth('api')->user()->id;

            // IMAGE GRADUTAION PHOTO awcertificate
            $has_certific_logo = request()->hasfile('awcertificate');

            if($has_certific_logo){
                $certific_logo = request('awcertificate');
                $extension = $certific_logo->getClientOriginalExtension(); // getting image extension
                $filename = remove_space_dots_replace_underscore($award->name) . '_' . time() . mt_rand(1000, 9999) . '.'.$extension;

                Image::make($request->awcertificate)->save(public_path('uploads/awcertificate/').$filename);

                $award->awcertificate  =  $filename;
            }
            

            $award->save();

            DB::commit();
            // DB::rollBack();

            return response()->json(['status' => 'success', 'message' => 'Award Updated successfully']);
       }
       catch( \Execption $e ) {
            DB::rollBack();

            return response()->json(['status' => 'error', 'message' => 'Something wrong'], 422);
       }
    }
}
