<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\CreateAccessInformationRequest;
use App\Models\AccessInformation;
use DB;
use Flash;
use App\Library\SslCommerz\SslCommerzNotification;

class AccessPaymentController extends Controller
{
    public function store_proceed(CreateAccessInformationRequest $request, AccessInformation $AccessInformation)
    {
        DB::beginTransaction();

        try {
            $input = $request->all();
	        /** @var AccessInformation $accessInformation */
	        $accessInformation = AccessInformation::create($input);
	        Flash::success('Access Information saved successfully.');
            DB::commit();
	        return redirect()->action('WebController@home');

        } catch (\Exception $e) {
            DB::rollback();
            Flash::success('Some Thing is wrong.');
            return redirect()->action('WebController@home');
        }

    }


    public function proceedToSsl(CreateAccessInformationRequest $request, AccessInformation $AccessInformation)
    {
        # Here you have to receive all the order data to initate the payment.
        # Let's say, your oder transaction informations are saving in a table called "orders"
        # In "orders" table, order unique identity is "transaction_id". "status" field contain status of the transaction, "amount" is the order amount to be paid and "currency" is for storing Site Currency which will be checked with paid currency.
        $input = $request->all();
        $input['transaction_id'] = uniqid();
        $input['payment_amount'] = '100';
        $accessInformation = AccessInformation::create($input);

        $post_data = array();
        $post_data['total_amount'] = $accessInformation->payment_amount;; # You cant not pay less than 10
        $post_data['currency'] = "BDT";
        $post_data['tran_id'] = $accessInformation->transaction_id; // tran_id must be unique


        // 'full_name',
        // 'address_line_1',
        // 'address_line_2',
        // 'city',
        // 'state',
        // 'postal_code',
        // 'country',
        // 'email',
        // 'phone',
        // 'workshop_type',
        // 'payment_date',
        // 'valid_from',
        // 'valid_to',
        // 'payment_staus',
        // 'status'


        # CUSTOMER INFORMATION
        $post_data['cus_name'] = $accessInformation->full_name;
        $post_data['cus_email'] = $accessInformation->email;
        $post_data['cus_add1'] = $accessInformation->address_line_1;
        $post_data['cus_add2'] = $accessInformation->address_line_2;
        $post_data['cus_city'] = $accessInformation->city;
        $post_data['cus_state'] = $accessInformation->state;
        $post_data['cus_postcode'] = $accessInformation->postal_code;
        $post_data['cus_country'] = "Bangladesh";
        $post_data['cus_phone'] = $accessInformation->phone;
        $post_data['cus_fax'] = "";

        # SHIPMENT INFORMATION
        $post_data['ship_name'] = $accessInformation->full_name;
        $post_data['ship_add1'] = $accessInformation->address_line_1;
        $post_data['ship_add2'] = $accessInformation->address_line_2;
        $post_data['ship_city'] = $accessInformation->city;
        $post_data['ship_state'] = $accessInformation->state;
        $post_data['ship_postcode'] = $accessInformation->postal_code;
        $post_data['ship_phone'] = $accessInformation->phone;
        $post_data['ship_country'] = "Bangladesh";

        $post_data['shipping_method'] = "NO";
        $post_data['product_name'] = "A2I REGISTRATION";
        $post_data['product_category'] = "Subscription";
        $post_data['product_profile'] = "Subscription Registration";

        # OPTIONAL PARAMETERS
        // $post_data['value_a'] = "ref001";
        // $post_data['value_b'] = "ref002";
        // $post_data['value_c'] = "ref003";
        // $post_data['value_d'] = "ref004";

        #Before  going to initiate the payment order status need to insert or update as Pending.
        // $update_product = DB::table('access_informations')
        //     ->where('transaction_id', $post_data['tran_id'])
        //     ->updateOrInsert([
        //         'name' => $post_data['cus_name'],
        //         'email' => $post_data['cus_email'],
        //         'phone' => $post_data['cus_phone'],
        //         'amount' => $post_data['total_amount'],
        //         'status' => 'Pending',
        //         'address' => $post_data['cus_add1'],
        //         'transaction_id' => $post_data['tran_id'],
        //         'currency' => $post_data['currency']
        //     ]);

        $sslc = new SslCommerzNotification();
        # initiate(Transaction Data , false: Redirect to SSLCOMMERZ gateway/ true: Show all the Payement gateway here )
        $payment_options = $sslc->makePayment($post_data, 'hosted');

        if (!is_array($payment_options)) {
            print_r($payment_options);
            $payment_options = array();
        }

    }


    public function success(Request $request)
    {
        echo "Transaction is Successful";

        $tran_id = $request->input('tran_id');
        $amount = $request->input('amount');
        $currency = $request->input('currency');

        $sslc = new SslCommerzNotification();

        #Check order status in order tabel against the transaction id or order id.
        $order_detials = DB::table('access_informations')
            ->where('transaction_id', $tran_id)
            ->select('transaction_id', 'payment_status', 'payment_amount', 'status')->first();

        if (!$order_detials->payment_status) {
            $validation = $sslc->orderValidate($tran_id, $amount, $currency, $request->all());

            if ($validation == TRUE) {
                /*
                That means IPN did not work or IPN URL was not set in your merchant panel. Here you need to update order status
                in order table as Processing or Complete.
                Here you can also sent sms or email for successfull transaction to customer
                */
                $update_product = DB::table('access_informations')
                    ->where('transaction_id', $tran_id)
                    ->update(['payment_status' => 1, 'status' => 1, 'payment_date' => now()]);

                Flash::success('You have paid successfully. Your Transaction ID: ' . $tran_id);
                return redirect()->action('WebController@home');


            } else {
                /*
                That means IPN did not work or IPN URL was not set in your merchant panel and Transation validation failed.
                Here you need to update order status as Failed in order table.
                */
                $update_product = DB::table('access_informations')
                    ->where('transaction_id', $tran_id)
                    ->update(['status' => 0, 'payment_status' => 0]);
                echo "validation Fail";
            }
        } else if ($order_detials->payment_status == 1) {
            /*
             That means through IPN Order status already updated. Now you can just show the customer that transaction is completed. No need to udate database.
             */
            echo "Transaction is successfully Completed";
        } else {
            #That means something wrong happened. You can redirect customer to your product page.
            echo "Invalid Transaction";
        }


    }

    public function fail(Request $request)
    {
        $tran_id = $request->input('tran_id');

        $order_detials = DB::table('access_informations')
            ->where('transaction_id', $tran_id)
            ->select('transaction_id', 'payment_status', 'payment_amount', 'status')->first();

        if (!$order_detials->payment_status) {
            $update_product = DB::table('access_informations')
                ->where('transaction_id', $tran_id)
                ->update(['payment_status' => 0]);

                Flash::error('Transaction is Falied.');
                

        } else if ($order_detials->payment_status) {
            Flash::success('Transaction is already Successful');
        } else {
            Flash::error('Transaction is Invalid');
        }

        return redirect()->action('WebController@home');

    }

    public function cancel(Request $request)
    {
        $tran_id = $request->input('tran_id');

        $order_detials = DB::table('access_informations')
            ->where('transaction_id', $tran_id)
            ->select('transaction_id', 'payment_status', 'payment_amount', 'status')->first();

        if (!$order_detials->payment_status) {
            $update_product = DB::table('access_informations')
                ->where('transaction_id', $tran_id)
                ->update(['payment_status' => 0]);
            Flash::success('Transaction is Cancelled.');
        } else if ($order_detials->payment_status) {
             Flash::success('Transaction is Successful.');
        } else {
            Flash::success('Transaction is Invalid.');
        }
         return redirect()->action('WebController@home');


    }

}
