<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

//https://blog.pusher.com/laravel-jwt/

// Route::middleware('auth:api')->get('/user', function (Request $request) {
//     return $request->user();
// });




Route::post('register', 'Api\AuthController@register');
Route::post('login', 'Api\AuthController@login');
Route::get('logout', 'Api\AuthController@logout');

Route::post('update-profile', 'Api\AuthController@update_profile');

Route::get('open', 'Api\MainController@open');



Route::get('/get_menu_data/{slug}', 'Api\SettingController@get_menu_data');


Route::group(['middleware' => ['jwt.verify']], function() {

    Route::get('closed', 'Api\MainController@closed');

    Route::get('me', 'Api\AuthController@me');


    Route::get('my-events', 'Api\DashboardController@my_events');
    Route::get('my-posted-jobs', 'Api\DashboardController@my_posted_jobs');

    Route::post('post-job', 'Api\DashboardController@post_job');
    Route::post('update-job/{id}', 'Api\DashboardController@update_job');

    Route::get('my-applied-jobs', 'Api\DashboardController@my_applied_jobs');
    Route::get('my-awards', 'Api\DashboardController@my_awards');

});

// Route::post('student/register', '\Api\StudentController@store');
Route::post('student/register', 'Api\StudentController@store');
Route::post('forgot-password', 'Api\AuthController@forgot_password');
Route::post('change-password', 'Api\AuthController@change_password');


// HOME DATA
Route::get('get-slider', 'Api\MainController@get_slider');
Route::get('get-gallery-publications', 'Api\MainController@get_gallery_publications');
Route::get('get-testimonials', 'Api\MainController@get_testimonials');


// Blog
Route::get('get-blogs', 'Api\BlogController@get_blogs');
Route::get('get-category-blogs/{cat_id}', 'Api\BlogController@get_category_blogs');
Route::get('blog/{id}', 'Api\BlogController@show');

Route::get('get-popular-blog', 'Api\BlogController@get_popular_blog');
Route::get('get-popular-category', 'Api\BlogController@get_popular_category');
Route::get('get-home-blog', 'Api\BlogController@get_home_blog');

// Gallery
Route::get('get-gallery', 'Api\MainController@get_gallery');
Route::get('get-gallery-by-category/{category_id}', 'Api\MainController@get_gallery_by_category');

// Event
Route::get('get-events', 'Api\EventController@get_events');
Route::get('get-event-lead', 'Api\EventController@get_event_lead');
Route::get('event/{id}', 'Api\EventController@show');

Route::post('/event/subscribe/{event_id}', 'Api\EventController@subscribe_event');




Route::get('join-event/{id}', 'Api\EventController@join_event');


// Job
Route::get('get-jobs', 'Api\JobController@get_jobs');
Route::get('job/{id}', 'Api\JobController@show');

Route::post('/job/subscribe/{event_id}', 'Api\JobController@subscribe_job');

// Event
Route::get('get-stories', 'Api\StoryController@get_stories');
Route::get('get-story-lead', 'Api\StoryController@get_story_lead');
Route::get('story/{id}', 'Api\StoryController@show');


// Member Categories
Route::get('get-member-categories', 'Api\MainController@get_member_categories');

// Newsletter Store
Route::post('store-newsletter', 'Api\MainController@store_newsletter');

// Notice
Route::get('get-notices', 'Api\MainController@get_notices');

// publication
Route::get('get-publications', 'Api\MainController@get_publications');

// settings
Route::get('get-settings', 'Api\SettingController@get_setting_data');

// page
Route::get('page/{id}', 'Api\MainController@page_show');

// Contact
Route::post('contact_store', 'Api\MainController@contact_store');


// Blog
Route::get('get-students', 'Api\StudentController@get_students');
