@section('title') Register @stop
@extends('front.layout.master-inner')
@section('content-inner')
	<div class="kode_contact_des">
		<div class="container">
			<div class="row">
				<div class="kode_contact_field">
					<div class="section_hdg hdg_2 hdg_3">
						<a href="#"><img src="images/hdg-img.png" alt=""></a>
						<h3>Student Register</h3>
						<span><i class="fa icon-building"></i></span>
					</div>

					@include('components.errors')
					<div class="div-multistep-box">
						<!-- MultiStep Form -->
						<div class="container-fluid" id="grad1">
						   <div class="row justify-content-center mt-0">
						      <div class="offset-md-2 col-11 col-sm-9 col-md-7 col-lg-8 text-center p-0 mb-2">
						         <div class="card px-0 pt-4 pb-0 mb-3">
						            {{-- <h2><strong>Sign Up Your User Account</strong></h2>
						            <p>Fill all form field to go to next step</p> --}}
						            <div class="row">
						               <div class="col-md-12 mx-0">
						                  <form id="msform" class="reset_v2" method="POST" action="{{ action('WebController@student_register_store')}}">
						                     <!-- progressbar -->
						                     <ul id="progressbar">
						                        <li class="active" id="account"><strong>Account</strong></li>
						                        <li id="personal"><strong>Personal</strong></li>
						                        <li id="payment"><strong>Payment</strong></li>
						                        <li id="confirm"><strong>Finish</strong></li>
						                     </ul>
						                     <!-- fieldsets -->
						                     <fieldset>
						                        <div class="form-card">
						                           <h2 class="fs-title">Account Information</h2>
						                           <!-- Name Field -->
											        <div class="form-group col-sm-6">
											            {!! Form::label('name', 'Name:') !!}
											            {!! Form::text('name', null, ['class' => 'form-control']) !!}
											        </div>

											        <!-- Date Of Birth Field -->
											        <div class="form-group col-sm-6">
											            {!! Form::label('date_of_birth', 'Date Of Birth:') !!}
											            {!! Form::date('date_of_birth', null, ['class' => 'form-control','id'=>'date_of_birth']) !!}
											        </div>

											        @push('scripts')
											            <script type="text/javascript">
											                $('#date_of_birth').datetimepicker({
											                    format: 'YYYY-MM-DD HH:mm:ss',
											                    useCurrent: false
											                })
											            </script>
											        @endpush
											        <!-- Father Name Field -->
											        <div class="form-group col-sm-6">
											            {!! Form::label('father_name', 'Father Name:') !!}
											            {!! Form::text('father_name', null, ['class' => 'form-control']) !!}
											        </div>

											        <!-- Mother Name Field -->
											        <div class="form-group col-sm-6">
											            {!! Form::label('mother_name', 'Mother Name:') !!}
											            {!! Form::text('mother_name', null, ['class' => 'form-control']) !!}
											        </div>

											        <!-- Gender Field -->
											        <div class="form-group col-sm-12">
											            {!! Form::label('gender', 'Gender:') !!}
											            <label class="radio-inline">
											                {!! Form::radio('gender', "Male", null) !!} Male
											            </label>

											            <label class="radio-inline">
											                {!! Form::radio('gender', "Female", null) !!} Female
											            </label>

											        </div>

											        <!-- Country Id Field -->
											        <div class="form-group col-sm-6">
											            {!! Form::label('country_id', 'Country:') !!}
											            {!! Form::select('country_id', \App\Models\Country::pluck('name', 'id'), null, ['class' => 'form-control']) !!}
											        </div>

											        <!-- Address Field -->
											        <div class="form-group col-sm-12 col-lg-12">
											            {!! Form::label('address', 'Address:') !!}
											            {!! Form::textarea('address', null, ['class' => 'form-control']) !!}
											        </div>

											        <!-- Student Type Field -->
											        <div class="form-group col-sm-12">
											            {!! Form::label('student_type', 'Student Type:') !!}
											            <label class="radio-inline">
											                {!! Form::radio('student_type', "adults", null) !!} Adult
											            </label>

											            <label class="radio-inline">
											                {!! Form::radio('student_type', "kids", null) !!} Kids
											            </label>

											        </div>

											        <!-- Phone Field -->
											        <div class="form-group col-sm-6">
											            {!! Form::label('phone', 'Phone:') !!}
											            {!! Form::number('phone', null, ['class' => 'form-control']) !!}
											        </div>

											        <!-- Home Phone Field -->
											        <div class="form-group col-sm-6">
											            {!! Form::label('home_phone', 'Home Phone:') !!}
											            {!! Form::number('home_phone', null, ['class' => 'form-control']) !!}
											        </div>

											        <!-- 'bootstrap / Toggle Switch Sms Notify Field' -->
											        <div class="form-group col-sm-6">
											            {!! Form::label('sms_notify', 'Sms Notify:') !!}
											            <label class="checkbox-inline">
											                {!! Form::hidden('sms_notify', 0) !!}
											                {!! Form::checkbox('sms_notify', 1, null,  ['data-toggle' => 'toggle']) !!}
											            </label>
											        </div>


											        

											        <!-- Skype Id Field -->
											        <div class="form-group col-sm-6">
											            {!! Form::label('skype_id', 'Skype Id:') !!}
											            {!! Form::text('skype_id', null, ['class' => 'form-control']) !!}
											        </div>

											        <!-- Zoom Id Field -->
											        <div class="form-group col-sm-6">
											            {!! Form::label('zoom_id', 'Zoom Id:') !!}
											            {!! Form::text('zoom_id', null, ['class' => 'form-control']) !!}
											        </div>


						                        </div>
						                        <input type="button" name="next" class="next action-button" value="Next Step" />
						                     </fieldset>
						                     <fieldset>
						                        <div class="form-card">
						                           <h2 class="fs-title">Personal Information</h2>
						                           <!-- Email Field -->
											        <div class="form-group col-sm-6">
											            {!! Form::label('email', 'Email:') !!}
											            {!! Form::email('email', null, ['class' => 'form-control']) !!}
											        </div>

											        <!-- Password Field -->
											        <div class="form-group col-sm-6">
											            {!! Form::label('password', 'Password:') !!}
											            {!! Form::password('password', ['class' => 'form-control']) !!}
											        </div>
						                        </div>
						                        <input type="button" name="previous" class="previous action-button-previous" value="Previous" /> <input type="button" name="next" class="next action-button" value="Next Step" />
						                     </fieldset>
						                     <fieldset>
						                        <div class="form-card">
						                           <h2 class="fs-title">Payment Information</h2>

						                           <input name="package_id" id="package_id" type="hidden" value=""> 
						                           {{-- @php
						                           	$packages = \App\Models\Package::withCategory()->pluck('category_package_name', 'id');
						                           @endphp

						                           {!! Form::label('package_id', 'Package:') !!}
										           {!! Form::select('package_id', $packages, null, ['class' => 'form-control']) !!} --}}

										           <!--THIT PRICING WRAP START-->
													<div class="kode_pricing_wrap" id="naba-courses">
															<!--SECTION HDG START-->
															<ul class="nav nav-tabs naba-course-tab" id="myTab" role="tablist">
																@foreach(\App\Models\PackageCategory::active()->get() as $package_category)
																<li class="nav-item">
																  <a class="nav-link {{ $loop->first ? 'active' : '' }}" id="home-tab" data-toggle="tab" href="#package-cat-id-{{$package_category->id}}" role="tab" aria-controls="package-cat-id-{{$package_category->id}}"
																aria-selected="true">{{ $package_category->name }}</a>
																</li>
																@endforeach
															</ul>
															<div class="row">
																<div class="tab-content naba-course-tab-content" id="myTabContent">
																	@foreach(\App\Models\PackageCategory::active()->get() as $package_category)
																		<div class="tab-pane fade {{ $loop->first ? 'active in' : '' }}" id="package-cat-id-{{$package_category->id}}" role="tabpanel" aria-labelledby="package-cat-id-{{$package_category->id}}">
																			<!--SECTION HDG END-->
																				@foreach($package_category->packages as $package)
																					<div class="col-md-3">
																						<div class="kode_pricing_des naba-single-course">
																							<h4>{{ $package->name }}</h4>
																							<div class="kode_pricing_dollar">
																								<h3>${{ $package->price }}</h3>
																								{{-- <p>{{ $package->short_name }}</p> --}}
																							</div>
																							{{-- <ul class="pricing_list">
																								<li><a href="#">{{ $package->valid_days }} Days</a></li>
																								<li><a href="#">100% money back guarantee </a></li>
																							</ul> --}}
																							<a class="medium_btn background-bg-dark naba-course-select" href="{{ action('WebController@student_register')}}?package_id={{ $package->id }}" package_id="{{ $package->id }}">Select</a>
																						</div>
																					</div>
																				@endforeach
																		</div>
																	@endforeach
																</div>
															</div>
													</div>
													<!--THIT PRICING WRAP END-->

						                        </div>

						                        <input type="button" name="previous" class="previous action-button-previous" value="Previous" /> 

						                        <input type="submit" name="make_payment" class="action-button" value="Proceed To Paypal" />
						                     </fieldset>
						                     {{-- <fieldset>
						                        <div class="form-card">
						                           <h2 class="fs-title text-center">Success !</h2>
						                           <br><br>
						                           <div class="row justify-content-center">
						                              <div class="col-3"> <img width="300" src="https://img.icons8.com/color/96/000000/ok--v2.png" class="fit-image"> </div>
						                           </div>
						                           <br><br>
						                           <div class="row justify-content-center">
						                              <div class="col-7 text-center">
						                                 <h5>You Have Successfully Signed Up</h5>
						                              </div>
						                           </div>
						                        </div>
						                     </fieldset> --}}
						                  </form>
						               </div>
						            </div>
						         </div>
						      </div>
						   </div>
						</div>						
					</div><!--end multistep-form-->
				</div>
			</div>
		</div>	
		<!--CONTAINER END-->
	</div>
@endsection

@section('script')

	<script type="text/javascript">
	    $(document).ready(function(){

		var current_fs, next_fs, previous_fs; //fieldsets
		var opacity;

		$(".next").click(function(){

		current_fs = $(this).parent();
		next_fs = $(this).parent().next();

		//Add Class Active
		$("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");

		//show the next fieldset
		next_fs.show();
		//hide the current fieldset with style
		current_fs.animate({opacity: 0}, {
		step: function(now) {
		// for making fielset appear animation
		opacity = 1 - now;

		current_fs.css({
		'display': 'none',
		'position': 'relative'
		});
		next_fs.css({'opacity': opacity});
		},
		duration: 600
		});
		});

		$(".previous").click(function(){

		current_fs = $(this).parent();
		previous_fs = $(this).parent().prev();

		//Remove class active
		$("#progressbar li").eq($("fieldset").index(current_fs)).removeClass("active");

		//show the previous fieldset
		previous_fs.show();

		//hide the current fieldset with style
		current_fs.animate({opacity: 0}, {
		step: function(now) {
		// for making fielset appear animation
		opacity = 1 - now;

		current_fs.css({
		'display': 'none',
		'position': 'relative'
		});
		previous_fs.css({'opacity': opacity});
		},
		duration: 600
		});
		});

		$('.radio-group .radio').click(function(){
		$(this).parent().find('.radio').removeClass('selected');
		$(this).addClass('selected');
		});

		$(".submit").click(function(){
		return false;
		})

		});



		var closestRoot = $('#naba-courses');
		var selectedPackageHiddenInputValue = $('#package_id');

	    $('.naba-course-select').on('click', function(e){
	    	e.preventDefault();

	    	closestRoot.find('.naba-course-select').removeClass('active');
	    	closestRoot.find('.naba-course-select').text('SELECT');
	    	var self = $(this);
	    	var package_id = self.attr('package_id');
	    	var closestSingleDiv = self.parent('.naba-single-course');
	    	// closestSingleDiv.addClass('active');
	    	self.text('SELECTED')
	    	self.addClass('active')

	    	selectedPackageHiddenInputValue.val(package_id);

	    	// alert(closestSingleDiv);


	    });



	</script>

@endsection