<div class="table-responsive">
    <table class="table" id="newsletters-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Email</th>
        <th>Status</th>
                <th colspan="3">Action</th>
            </tr>
        </thead>
        <tbody>
        @foreach($newsletters as $newsletter)
            <tr>
                <td>{{$newsletter->id}}</td>
                <td>{{ $newsletter->email }}</td>
                <td>{!! $newsletter->status_buttons() !!}</td>
                <td>
                    {!! Form::open(['route' => ['admin.newsletters.destroy', $newsletter->id], 'method' => 'delete']) !!}
                    <div class='btn-group'>
                        <a href="{{ route('admin.newsletters.show', [$newsletter->id]) }}" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-eye-open"></i></a>
                        <a href="{{ route('admin.newsletters.edit', [$newsletter->id]) }}" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-edit"></i></a>
                        {!! Form::button('<i class="glyphicon glyphicon-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'onclick' => "return confirm('Are you sure?')"]) !!}
                    </div>
                    {!! Form::close() !!}
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
</div>
