<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class Publication
 * @package App\Models
 * @version May 22, 2021, 6:26 am UTC
 *
 * @property string title
 * @property string image
 * @property string attachment
 * @property string description
 * @property integer status
 */
class Publication extends Model
{

    public $table = 'publications';
    




    public $upload_path = 'uploads/publications';

    public $search_fields = [
        'title',
        'image',
        'attachment',
        'description',
        'status'
    ];
    public $fillable = [
        'title',
        'image',
        'attachment',
        'description',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'title' => 'string',
        'image' => 'string',
        'attachment' => 'string',
        'description' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'title' => 'required',
        'image' => 'required|image|mimes:jpeg,png,jpg|max:2048',
        'attachment' => 'required|mimes:pdf|max:10000'
    ];

    
}
