<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class Notice
 * @package App\Models
 * @version March 29, 2021, 10:19 am UTC
 *
 * @property string title
 * @property string description
 * @property string image
 * @property integer status
 */
class Notice extends Model
{

    public $table = 'notices';
    




    public $upload_path = 'uploads/notices';

    public $search_fields = [
        'title',
        'description',
        'image',
        'status'
    ];
    public $fillable = [
        'title',
        'description',
        'image',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'title' => 'string',
        'description' => 'string',
        'image' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'title' => 'required',
        'image' => 'image|mimes:jpeg,png,jpg|max:2048'
    ];

    
}
