<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class Newsletter
 * @package App\Models
 * @version March 29, 2021, 9:42 am UTC
 *
 * @property string email
 * @property integer status
 */
class Newsletter extends Model
{

    public $table = 'newsletters';
    




    public $upload_path = 'uploads/newsletters';

    public $search_fields = [
        'email',
        'status'
    ];
    public $fillable = [
        'email',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'email' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'email' => 'required'
    ];

    
}
