<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class GalleryCategory
 * @package App\Models
 * @version March 21, 2021, 12:16 pm UTC
 *
 * @property string name
 * @property integer status
 */
class GalleryCategory extends Model
{

    public $table = 'gallery_categories';

    public $search_fields = [
        'name',
        'status'
    ];
    public $fillable = [
        'name',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'name' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required'
    ];

    
}
