<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class EventSubscriber
 * @package App\Models
 * @version March 28, 2021, 12:09 pm UTC
 *
 * @property \App\Models\Event event
 * @property \App\Models\Student student
 * @property integer event_id
 * @property integer student_id
 * @property string name
 * @property string address
 * @property string email
 * @property string phone
 * @property integer status
 */
class EventSubscriber extends Model
{

    public $table = 'event_subscribers';
    




    public $upload_path = 'uploads/event_subscribers';

    public $search_fields = [
        'event_id',
        'student_id',
        'name',
        'address',
        'email',
        'phone',
        'status'
    ];
    public $fillable = [
        'event_id',
        'student_id',
        'name',
        'address',
        'email',
        'phone',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'event_id' => 'integer',
        'student_id' => 'integer',
        'name' => 'string',
        'address' => 'string',
        'email' => 'string',
        'phone' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required',
        'email' => 'required',
        'phone' => 'required'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function event()
    {
        return $this->belongsTo(\App\Models\Event::class, 'event_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function student()
    {
        return $this->belongsTo(\App\Models\Student::class, 'student_id', 'id');
    }
}
