<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class BlogCategory
 * @package App\Models
 * @version April 7, 2021, 9:13 am UTC
 *
 * @property string name
 * @property integer status
 */
class BlogCategory extends Model
{

    public $table = 'blog_categories';
    




    public $upload_path = 'uploads/blog_categories';

    public $search_fields = [
        'name',
        'status'
    ];
    public $fillable = [
        'name',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'name' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required'
    ];

    
}
