<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TestimonialResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $testimonial = new \App\Models\Testimonial;
        $array =  parent::toArray($request);
        $array['image_src'] = url('/') . '/' . $testimonial->upload_path . '/' . $this->image;
        $array['short_description'] = \Illuminate\Support\Str::limit(strip_tags($this->description), $limit = 250, $end = '...');
        return $array;
    }
}
