<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Http\Resources\StoryResource;

class StoryController extends Controller
{
    public function get_stories(){
        $stories = \App\Models\Story::active()->paginate(6);
        return StoryResource::collection($stories);
    }

    public function show($id){
        $stories = \App\Models\Story::find($id);
        return new StoryResource($stories);
    }

    public function get_story_lead(){
        $story = \App\Models\Story::latest()->first();
        return new StoryResource($story);
    }
}
