<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateStudentRequest;
use App\Http\Requests\UpdateStudentRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\Student;
use Illuminate\Http\Request;
use Flash;
use Response;
use DB;

class StudentController extends AppBaseController
{
    /**
     * Display a listing of the Student.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        /** @var Student $students */
        $students = Student::withSearch()->paginate(10);

        return view('admin.students.index')
            ->with('students', $students);
    }

    public function register(Request $request, Student $student){

        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'password' => 'required',
            'gender' => 'required',
            'student_type' => 'required',
            'email' => 'required|email',
            'image' => 'image|mimes:jpeg,png,jpg|max:2048'
        ]);


        // when path null its come from model upload_path
        DB::beginTransaction();
        try {
            $input = $request->all();

            

            $input['image'] = $student->uploadFile($field = 'image', $save_title=$request->name, $path=null);

            if($request->email && $request->password){

                $user = new \App\User;
                $user->name = $request->name;
                $user->email = $request->email;
                $user->password = bcrypt($request->password);
                $user->save();

                $user->assignRole('Student');
            }

            unset($input['password']);

            /** @var Student $student */
            $student = Student::create($input);
            DB::commit();

        } catch (\Exception $e) {
            DB::rollback();
            // dd($e);
            Flash::success('Some Thing is wrong.');
            return back();
        }

        Flash::success('Student saved successfully.');

        return redirect(url('/'));
    }

    /**
     * Show the form for creating a new Student.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.students.create');
    }

    

    /**
     * Store a newly created Student in storage.
     *
     * @param CreateStudentRequest $request
     *
     * @return Response
     */
    public function store(CreateStudentRequest $request, Student $student)
    {
        // when path null its come from model upload_path
        
        DB::beginTransaction();

        try {
            $input = $request->all();

            $input['image'] = $student->uploadFile($field = 'image', $save_title=$request->name, $path=null);

            if($request->email && $request->password){

                $user = new \App\User;
                $user->name = $request->name;
                $user->email = $request->email;
                $user->password = bcrypt($request->password);
                $user->save();

                $user->assignRole('Student');
            }

            unset($input['password']);

            /** @var Student $student */
            $student = Student::create($input);
            DB::commit();

        } catch (\Exception $e) {

            DB::rollback();
            Flash::success('Some Thing is wrong.');
        }

        Flash::success('Student saved successfully.');

        return redirect(route('admin.students.index'));
    }

    /**
     * Display the specified Student.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var Student $student */
        $student = Student::find($id);

        if (empty($student)) {
            Flash::error('Student not found');

            return redirect(route('admin.students.index'));
        }

        return view('admin.students.show')->with('student', $student);
    }

    /**
     * Show the form for editing the specified Student.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var Student $student */
        $student = Student::find($id);

        if (empty($student)) {
            Flash::error('Student not found');

            return redirect(route('admin.students.index'));
        }

        return view('admin.students.edit')->with('student', $student);
    }

    /**
     * Update the specified Student in storage.
     *
     * @param int $id
     * @param UpdateStudentRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateStudentRequest $request)
    {
        /** @var Student $student */
        $student = Student::find($id);

        if (empty($student)) {
            Flash::error('Student not found');

            return redirect(route('admin.students.index'));
        }

        $student->fill($request->all());

        if($request->email && $request->password){
            $user = \App\User::where('email', $email)->first();
            $user->password = bcrypt($request->password);
            $user->save();
        }

        $student->image = $student->delete_existing_and_upload_file($field = 'image', $save_title=$request->name, $path=null);

        $student->save();

        Flash::success('Student updated successfully.');

        return redirect(route('admin.students.index'));
    }

    /**
     * Remove the specified Student from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var Student $student */
        $student = Student::find($id);

        if (empty($student)) {
            Flash::error('Student not found');

            return redirect(route('admin.students.index'));
        }

        $student->deleteImage($field='image'); // if exist image then delete

        $student->delete();

        Flash::success('Student deleted successfully.');

        return redirect(route('admin.students.index'));
    }
}
