// store.js 
import need from '~/mixin/need.js'

export const state = () => ({
    settingsData : null,
})

export const mutations = {
  updateLanguage(state){
    state.language = state.language == 1 ? 2 : 1;
  },

  setHelperData(state, helperData){
    state.helperData = helperData;
  },

  setSettingsData(state, settingsData){
    state.settingsData = settingsData;
  }

}

export const actions = {
  fetchSettingsData({commit}){
    this.$axios.get('get-settings').then((response) => {
      commit('setSettingsData', response.data);
    })
  }
}

export const getters = {

    getSetting : (state, getters, rootState, rootGetters) => (field) => {
      if(state.settingsData){
        return state.settingsData[field] ? state.settingsData[field].val : '';
      }
    },

    getSettingWithLoading : (state, getters, rootState, rootGetters) => (field, loadingText="...") => {
      var settingValue = rootGetters['setting/getSetting'](field);
      return settingValue ? settingValue : loadingText;
    },

    getDynamicSetting : (state, getters, rootState, rootGetters) => (field) => {
      var field_name = rootState.setting.language == 1 ? field : field + '_en';
      var value = rootGetters['setting/getSetting'](field_name);
      return value;
    },

    imgFromSettings : (state, getters, rootState, rootGetters) => (field) => {
      var img_name = rootGetters['setting/getSetting'](field);
      return process.env.apiBaseUrl +  "/uploads/settings/"  + img_name;
    },


    getHelper : (state, getters, rootState, rootGetters) => (field) => {
      if(state.helperData){
        return state.helperData[field];
      }
    },

    getLastUpdatedDate : (state, getters, rootState, rootGetters) => {
      var title_update = rootGetters['language/getLanguage']('title_update');
      var last_update_time = rootGetters['setting/getHelper']('last_update_time');
      return title_update + ' ' + rootGetters['language/translateDate'](last_update_time);
    },


    // ** Menu **/
    getMenuTitle : (state, getters, rootState, rootGetters) => (obj) => {
      // console.log(state.helperData.current_time);
      // return;-
        return obj.text;
    },


    hasMenuChildren : (state, getters, rootState, rootGetters) => (obj) => {
      // console.log(state.helperData.current_time);
      // return;-
      return;
      if(obj.hasOwnProperty('childrens')) {
        return true;
      } else {
        return false;
      }
    },

   
}