export default {
  env: {
    baseUrl: process.env.NODE_ENV !== 'production' ? 'http://live.abc-alumni.org' : 'http://live.abc-alumni.org',
    apiUrl: process.env.NODE_ENV !== 'production' ? 'https://admin.abc-alumni.org/api' : 'https://admin.abc-alumni.org/api',
    apiBaseUrl: process.env.NODE_ENV !== 'production' ? 'https://admin.abc-alumni.org' : 'https://admin.abc-alumni.org',
  },
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: 'ABCA | Association of Bangladesh China Alumni',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'UTF-8' },
      { name: 'viewport', content: 'width=device-width, initial-scale=1' },
      { hid: 'description', name: 'description', content: 'Association of Bangladesh-China Alumni (ABCA)' },
      { name: 'author', content: 'Technohaat IT Limited' },
      { name: 'author_url', content: 'https://technohaat.com/' },
      { name: 'developer_company', content: 'Technohaat IT Limited' },
      { name: 'developer_url', content: 'https://technohaat.com/' },

      { name: 'robots', content: 'index, follow' },
      { name: 'googlebot', content: 'index, follow' },
      { name: 'googlebot-news', content: 'index, follow' },

      { name: 'twitter:site', content: '@abc_alumni2020' },
      
      { property: 'og:site_name', content: 'Association of Bangladesh-China Alumni' },
      { property: 'og:type', content: 'article' },


    ],
    link: [
       // { rel: 'icon', type: 'image/ico', href: 'favicon.ico'  },
       { rel: 'stylesheet', type: 'text/css', href: '/css/bootstrap.css' },
       { rel: 'stylesheet', type: 'text/css', href: '/css/animate.css' },
       { rel: 'stylesheet', type: 'text/css', href: '/css/owl.carousel.css' },
       { rel: 'stylesheet', type: 'text/css', href: '//unpkg.com/swiper/swiper-bundle.min.css' },
       { rel: 'stylesheet', type: 'text/css', href: '/css/styles.css' },
       { rel: 'stylesheet', type: 'text/css', href: '/css/meanmenu.css' },
       { rel: 'stylesheet', type: 'text/css', href: '/css/magnific-popup.css' },
       { rel: 'stylesheet', type: 'text/css', href: '/css/font-awesome.min.css' },
       { rel: 'stylesheet', type: 'text/css', href: '//cdn.linearicons.com/free/1.0.0/icon-font.min.css' },
       { rel: 'stylesheet', type: 'text/css', href: '/css/rod.css' },
       { rel: 'stylesheet', type: 'text/css', href: '/css/temp.css' },
    ],

    script: [
      { type: 'text/javascript', src: '/js/libs/modernizr.custom.js', body: false },

      { type: 'text/javascript', src: '//unpkg.com/swiper@6.4.10/swiper-bundle.min.js', body: true },
      { type: 'text/javascript', src: '/js/libs/jquery-2.2.4.min.js', body: true },
      { type: 'text/javascript', src: '/js/libs/bootstrap.min.js', body: true },
      { type: 'text/javascript', src: '/js/libs/owl.carousel.min.js', body: true },
      { type: 'text/javascript', src: '/js/libs/jquery.meanmenu.js', body: true },
      { type: 'text/javascript', src: '/js/libs/jquery.syotimer.js', body: true },
      { type: 'text/javascript', src: '/js/libs/parallax.min.js', body: true },
      { type: 'text/javascript', src: '/js/libs/magnific-popup.min.js', body: true },
      { type: 'text/javascript', src: '/js/libs/jquery.waypoints.min.js', body: true }

      // { type: 'text/javascript', src: '/js/libs/vue2.1.7.js', body: true },
      // { type: 'text/javascript', src: '/js/libs/vue-carousel-3d.min.js', body: true },
      // { type: 'text/javascript', src: '/js/custom/main.js', async: true, body: true },
      // { type: 'text/javascript', src: '/js/custom/trigger.js', body: true },
    ]
  },

  // Global CSS: https://go.nuxtjs.dev/config-css
  css: [
  ],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: [
            '~/plugins/global.js',
            { src: '~plugins/vue-carousel-3d', ssr: false }
  ],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [
  ],

  // Modules: https://go.nuxtjs.dev/config-modules
   modules: [
    [
      'vue-social-sharing/nuxt',
      'vue-sweetalert2/nuxt',
      {
        confirmButtonColor: '#41b882',
        cancelButtonColor: '#ff7674',
        timer: 3000,
        position: 'top-end',
        showConfirmButton: false,
      }
    ],
    '@nuxtjs/axios',
    '@nuxtjs/auth-next',
  ],

  auth: {
    redirect: {
      login: '/auth/login',
      logout: '/auth/login',
      callback: '/login',
      home: '/'
    },
    strategies: {
      local: {
        token: {
          property: 'token',
          required: true,
          type: 'Bearer'
        },
        user: {
          property: 'data',
          // autoFetch: true
        },
        endpoints: {
          login: { url: '/login', method: 'post', propertyName: 'token' },
          logout: { url: '/logout', method: 'get' },
          user: { url: '/me', method: 'get', propertyName: 'data' }
        }
      }
    }
  },


  axios: {
    // extra config e.g
    // BaseURL: 'https://link-to-API'
    // baseURL: 'http://localhost:3001/api', // Used as fallback if no runtime config is provided
    baseURL: process.env.NODE_ENV !== 'production' ? 'https://admin.abc-alumni.org/api' : 'https://admin.abc-alumni.org/api',
  },

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
  }
}
