const webpack = require('webpack');
const merge = require('webpack-merge');
const path = require('path');
const VueLoaderPlugin = require('vue-loader/lib/plugin');

//const sassVars = require(__dirname + "/src/styles/theme.js");

var config = {
  entry: path.resolve(__dirname + '/src/index.js'),
  output: {
    path: path.resolve(__dirname + '/dist/'),
    filename: 'vue-fb-chat.js'
  },
  resolve: {
    alias: {
      styles: 'src/styles/global.scss'
    }
  },
  module: {
    rules: [
      {
        test: /\.vue$/,
        loader: 'vue-loader'
      },
      {
        test: /\.css$/,
        use: ['style-loader', 'css-loader', 'sass-loader']
      },
      {
        test: /\.scss$/,
        use: [{
            loader: "style-loader"
        }, {
            loader: "css-loader"
        }, {
            loader: "sass-loader"
        }]
      }
    ],
  },
  plugins: [
    new VueLoaderPlugin()
  ]
};

module.exports = [
  merge(config, {
    entry: path.resolve(__dirname + '/src/index.js'),
    output: {
      filename: 'vue-fb-chat.min.js',
      libraryTarget: 'window',
      library: 'VueFacebookChat',
    }
  }),
  merge(config, {
    entry: path.resolve(__dirname + '/src/ChatComponent.vue'),
    output: {
      filename: 'vue-fb-chat.js',
      libraryTarget: 'umd',
      library: 'vue-fb-chat',
      umdNamedDefine: true
    }
  })
];