"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectResources = void 0;
const error_message_1 = require("./error-message");
const injectResources = async (ctx, options, source, resources) => {
    const { injector } = options;
    const dist = injector.call(ctx, source, resources);
    const content = await dist;
    if (typeof content !== 'string') {
        throw new Error(error_message_1.errorMessage.invalidInjectorReturn);
    }
    return content;
};
exports.injectResources = injectResources;
//# sourceMappingURL=inject-resources.js.map