<p align="center"><img align="center" style="width:320px" src="./.github/nuxt.png"/></p><br/>
<p align="center">
  <a href="https://github.com/nuxt/nuxt.js/actions?query=branch%3Adev+event%3Apush"><img src="https://github.com/nuxt/nuxt.js/workflows/test/badge.svg?branch=dev&event=push" alt="Tests Status"></a>
  <a href="https://github.com/nuxt/nuxt.js/actions?query=branch%3Adev+event%3Apush"><img src="https://github.com/nuxt/nuxt.js/workflows/windows/badge.svg?branch=dev&event=push" alt="Windows Status"></a>
  <a href="https://codecov.io/gh/nuxt/nuxt.js"><img src="https://badgen.net/codecov/c/github/nuxt/nuxt.js/master" alt="Coverage Status"></a>
  <a href="https://www.npmjs.com/package/nuxt"><img src="https://badgen.net/npm/dm/nuxt" alt="Downloads"></a>
  <a href="https://www.npmjs.com/package/nuxt"><img src="https://badgen.net/npm/v/nuxt" alt="Version"></a>
  <a href="https://www.npmjs.com/package/nuxt"><img src="https://badgen.net/npm/license/nuxt" alt="License"></a>
  <a href="https://discord.nuxtjs.org/"><img src="https://badgen.net/badge/Discord/join-us/7289DA" alt="Discord"></a>
 </p>
 <p align="center">
  <a href="#platinum-sponsors" alt="Platinum Sponsors on Open Collective"><img src="https://opencollective.com/nuxtjs/tiers/platinum-sponsors/badge.svg" /></a>
  <a href="#gold-sponsors" alt="Gold Sponsors on Open Collective"><img src="https://opencollective.com/nuxtjs/tiers/gold-sponsors/badge.svg" /></a>
  <a href="#silver-sponsors" alt="Silver Sponsors on Open Collective"><img src="https://opencollective.com/nuxtjs/tiers/silver-sponsors/badge.svg" /></a>
  <a href="#bronze-sponsors" alt="Bronze Sponsors on Open Collective"><img src="https://opencollective.com/nuxtjs/tiers/bronze-sponsors/badge.svg" /></a>
  <a href="#nuxters" alt="Nuxters on Open Collective"><img src="https://opencollective.com/nuxtjs/tiers/nuxters/badge.svg" /></a>
  <a href="https://oc.nuxtjs.org/"><img src="https://img.shields.io/badge/Support%20us-Open%20Collective-41B883.svg" alt="Support us"></a>
</p>
<p align="center">
  <a href="https://otechie.com/nuxt?ref=badge"><img src="https://api.otechie.com/consultancy/nuxt/badge.svg" alt="Hire Nuxt"></a>
</p>

> Build your next Vue.js application with confidence using Nuxt: a framework making web development simple and powerful.

## Links

- 📘 Documentation: [https://nuxtjs.org](https://nuxtjs.org)
- 👥 Community: [cmty.app/nuxt](https://cmty.app/nuxt)
- 🎬 Video: [1 minute demo](https://www.youtube.com/watch?v=kmf-p-pTi40)
- 🐦 Twitter: [@nuxt_js](https://twitter.nuxtjs.org/)
- 💬 Chat: [Discord](https://discord.nuxtjs.org/)
- 🌟 [AwesomeNuxt](https://awesome.nuxtjs.org/)
- 👉 [Play with Nuxt online](https://template.nuxtjs.org)

## Features

- Automatic transpilation and bundling (with webpack and babel)
- Hot code reloading
- Server-side rendering OR Single Page App OR Static Generated, you choose :fire:
- Static file serving. `./static/` is mapped to `/`
- Configurable with a `nuxt.config.js` file
- Custom layouts with the `layouts/` directory
- Middleware
- Code splitting for every `pages/`
- Loading just the critical CSS (page-level)

Learn more at <https://nuxtjs.org>.

## Getting started

```sh
$ npx create-nuxt-app <project-name>
```

It's as simple as that!

Learn more at https://nuxtjs.org/guide/installation

## Examples

Please take a look at <https://nuxtjs.org/examples> or directly in <https://github.com/nuxt/nuxt.js/tree/dev/examples>.

## Production deployment

To deploy, instead of running nuxt, you probably want to build ahead of time. Therefore, building and starting are separate commands:

```bash
nuxt build
nuxt start
```

Learn more at https://nuxtjs.org/guide/commands#production-deployment

## Consulting from the Nuxt team

Get help with that tough bug or make sure your Nuxt app is ready to deploy. For $250 an hour, get technical support, advice, code reviews, and development from the Nuxt core team: [Hire Nuxt on Otechie](https://otechie.com/nuxt?ref=readme)

## Professional support with TideLift

Professionally supported Nuxt is now available!

Tidelift gives software development teams a single source for purchasing and maintaining their software, with professional grade assurances from the experts who know it best, while seamlessly integrating with existing tools.

[Get supported Nuxt with the Tidelift Subscription](https://tidelift.com/subscription/pkg/npm-nuxt?utm_source=npm-nuxt&utm_medium=readme).

## Supporting Nuxt

Nuxt is an MIT-licensed open source project with its ongoing development made possible entirely by the support of these awesome backers.
Funds donated via OpenCollective are managed with transparent expenses and will be used for compensating work and expenses for core team members or sponsoring community events.

Support us with a monthly donation and help us continue our activities. [[Become a backer](https://opencollective.com/nuxtjs#contribute)]

### Platinum Sponsors

[![Open Collective Platinum Sponsors][platinum-sponsors-src]][platinum-sponsors-href]

### Gold Sponsors

[![Open Collective Gold Sponsors][gold-sponsors-src]][gold-sponsors-href]

### Silver Sponsors

[![Open Collective Silver Sponsors][silver-sponsors-src]][silver-sponsors-href]

### Bronze Sponsors

[![Open Collective Bronze Sponsors][bronze-sponsors-src]][bronze-sponsors-href]

## Contributors

Thank you to all our [contributors](https://github.com/nuxt/nuxt.js/graphs/contributors)!

[![Nuxt Contributors][contributors-src]][contributors-href]

## Contributing

[![Open in Gitpod](https://gitpod.io/button/open-in-gitpod.svg)](https://gitpod.io/#https://github.com/nuxt/nuxt.js)

Please refer to our [Contribution Guide](https://nuxtjs.org/guide/contribution-guide#codefund_ad)

## Cross-browser testing

Thanks to [BrowserStack](http://browserstack.com)!

<a href="http://browserstack.com"><img height="70" src="https://nuxtjs.org/browserstack.svg" alt="BrowserStack"></a>

## Automated testing

Thanks to [SauceLabs](https://saucelabs.com) for supporting Open Source <3

<a href="https://saucelabs.com"><img height="70" src="https://nuxtjs.org/saucelabs.svg" alt="SauceLabs"></a>

## Security

If you discover a security vulnerability regarding Nuxt, please send an e-mail to the team via security@nuxtjs.org! All security vulnerabilities will be promptly addressed.

## License

[MIT](https://github.com/nuxt/nuxt.js/blob/dev/LICENSE)

<!-- Open Collective Tiers -->
[platinum-sponsors-src]: https://opencollective.com/nuxtjs/tiers/platinum-sponsors.svg?avatarHeight=96&width=890
[platinum-sponsors-href]: https://opencollective.com/nuxtjs#contributors
[gold-sponsors-src]: https://opencollective.com/nuxtjs/tiers/gold-sponsors.svg?avatarHeight=80&width=890
[gold-sponsors-href]: https://opencollective.com/nuxtjs#contributors
[silver-sponsors-src]: https://opencollective.com/nuxtjs/tiers/silver-sponsors.svg?avatarHeight=64&width=890
[silver-sponsors-href]: https://opencollective.com/nuxtjs#contributors
[bronze-sponsors-src]: https://opencollective.com/nuxtjs/tiers/bronze-sponsors.svg?avatarHeight=48&width=890
[bronze-sponsors-href]: https://opencollective.com/nuxtjs#contributors
[nuxters-src]: https://opencollective.com/nuxtjs/tiers/nuxters.svg?width=890&button=false
[nuxters-href]: https://opencollective.com/nuxtjs#contributors
[contributors-src]: https://opencollective.com/nuxtjs/contributors.svg?width=890&button=false
[contributors-href]: https://github.com/nuxt/nuxt.js/graphs/contributors
