export default {
	methods : {
		successMessage(data=null){
			this.$swal.fire({
			  icon: data ? data.status : 'success',
			  title: data ? data.message : 'Done successfully',
			  confirmButtonColor: '#ccc',
			  position: 'center',
			})

		},

		validationError(){
			   this.$swal.fire({
				icon: 'error',
				title: 'Oops...',
				text: 'please fill form correctly',
			});
		},
		errorMessage(message){
			   this.$swal.fire({
				icon: 'error',
				title: 'Oops...',
				text: message,
			});
		},
		needLoginMessage(){
			  this.$swal.fire({
				icon: 'error',
				title: 'Oops...',
				text: 'You need to login to view this page',
			});
		},
		serialize(obj, prefix=null) {
          var str = [],
            p;
          for (p in obj) {
            if (obj.hasOwnProperty(p)) {
              var k = prefix ? prefix + "[" + p + "]" : p,
                v = obj[p];
              str.push((v !== null && typeof v === "object") ?
                serialize(v, k) :
                encodeURIComponent(k) + "=" + encodeURIComponent(v));
            }
          }
          return str.join("&");
        }
	}
}