import * as external from '~/components/helper/external.js'
export default {
	mounted(){

        //Page cursors
        $(window).mousemove(function(e) {
            $(".cursor").css({
                left: e.pageX,
                top: e.pageY
            })
        })

        $(".cursor-link")
        .on("mouseenter", function() {
            $('.cursor').addClass("active")
        })
        .on("mouseleave", function() {
            $('.cursor').removeClass("active")
        })


        // when mounted then remove main and install main.js
		external.initialize_body_script('/js/custom/main.js');
	},
	watch : {
		'$route' (to, from){
            // when page change then remove main and install main.js [MUST NEED TO ADD MIXIN AS mixin.js]
			external.initialize_body_script('/js/custom/main.js');
		}
	}
}