import Vue from 'vue'
import Router from 'vue-router'
import { normalizeURL, decode } from 'ufo'
import { interopDefault } from './utils'
import scrollBehavior from './router.scrollBehavior.js'

const _197119df = () => interopDefault(import('../pages/dashboard/index.vue' /* webpackChunkName: "pages/dashboard/index" */))
const _4df0cc78 = () => interopDefault(import('../pages/events/index.vue' /* webpackChunkName: "pages/events/index" */))
const _085360c1 = () => interopDefault(import('../pages/jobs/index.vue' /* webpackChunkName: "pages/jobs/index" */))
const _3f825204 = () => interopDefault(import('../pages/news/index.vue' /* webpackChunkName: "pages/news/index" */))
const _3e4a6cc3 = () => interopDefault(import('../pages/notice/index.vue' /* webpackChunkName: "pages/notice/index" */))
const _58f438de = () => interopDefault(import('../pages/stories/index.vue' /* webpackChunkName: "pages/stories/index" */))
const _6c4e07f4 = () => interopDefault(import('../pages/auth/forgot-password.vue' /* webpackChunkName: "pages/auth/forgot-password" */))
const _c629f2ac = () => interopDefault(import('../pages/auth/login.vue' /* webpackChunkName: "pages/auth/login" */))
const _788d99f2 = () => interopDefault(import('../pages/auth/register.vue' /* webpackChunkName: "pages/auth/register" */))
const _2149ae29 = () => interopDefault(import('../pages/dashboard/applied-jobs.vue' /* webpackChunkName: "pages/dashboard/applied-jobs" */))
const _10482232 = () => interopDefault(import('../pages/dashboard/my-events.vue' /* webpackChunkName: "pages/dashboard/my-events" */))
const _55fab26a = () => interopDefault(import('../pages/dashboard/my-profile.vue' /* webpackChunkName: "pages/dashboard/my-profile" */))
const _462c57e7 = () => interopDefault(import('../pages/static/About-Us.vue' /* webpackChunkName: "pages/static/About-Us" */))
const _78af4298 = () => interopDefault(import('../pages/static/alumuni-directory.vue' /* webpackChunkName: "pages/static/alumuni-directory" */))
const _353ab2bb = () => interopDefault(import('../pages/static/alumuni-general-members.vue' /* webpackChunkName: "pages/static/alumuni-general-members" */))
const _59b15941 = () => interopDefault(import('../pages/static/alumuni-live-members.vue' /* webpackChunkName: "pages/static/alumuni-live-members" */))
const _3b18cf99 = () => interopDefault(import('../pages/static/gallery.vue' /* webpackChunkName: "pages/static/gallery" */))
const _0ebee5e0 = () => interopDefault(import('../pages/static/members.vue' /* webpackChunkName: "pages/static/members" */))
const _20315ce0 = () => interopDefault(import('../pages/static/publications.vue' /* webpackChunkName: "pages/static/publications" */))
const _31b929fe = () => interopDefault(import('../pages/dashboard/award/create-award.vue' /* webpackChunkName: "pages/dashboard/award/create-award" */))
const _5c05bc62 = () => interopDefault(import('../pages/dashboard/award/edit-award.vue' /* webpackChunkName: "pages/dashboard/award/edit-award" */))
const _3500d5dc = () => interopDefault(import('../pages/dashboard/award/my-awards.vue' /* webpackChunkName: "pages/dashboard/award/my-awards" */))
const _92da3e7e = () => interopDefault(import('../pages/dashboard/job/create-job.vue' /* webpackChunkName: "pages/dashboard/job/create-job" */))
const _030ccb0f = () => interopDefault(import('../pages/dashboard/job/edit-job.vue' /* webpackChunkName: "pages/dashboard/job/edit-job" */))
const _0cacd0c2 = () => interopDefault(import('../pages/dashboard/job/posted-jobs.vue' /* webpackChunkName: "pages/dashboard/job/posted-jobs" */))
const _fd0f8da4 = () => interopDefault(import('../pages/gallery/category/_id.vue' /* webpackChunkName: "pages/gallery/category/_id" */))
const _533f4d1e = () => interopDefault(import('../pages/news/tag/_id.vue' /* webpackChunkName: "pages/news/tag/_id" */))
const _475f8023 = () => interopDefault(import('../pages/auth/___register.vue' /* webpackChunkName: "pages/auth/___register" */))
const _62793d2c = () => interopDefault(import('../pages/events/_id.vue' /* webpackChunkName: "pages/events/_id" */))
const _4b149f69 = () => interopDefault(import('../pages/jobs/_id.vue' /* webpackChunkName: "pages/jobs/_id" */))
const _ba1afe34 = () => interopDefault(import('../pages/news/_id.vue' /* webpackChunkName: "pages/news/_id" */))
const _0402c3eb = () => interopDefault(import('../pages/notice/_id.vue' /* webpackChunkName: "pages/notice/_id" */))
const _032446bc = () => interopDefault(import('../pages/page/_id.vue' /* webpackChunkName: "pages/page/_id" */))
const _b9524a74 = () => interopDefault(import('../pages/stories/_id.vue' /* webpackChunkName: "pages/stories/_id" */))
const _33424f9a = () => interopDefault(import('../pages/index.vue' /* webpackChunkName: "pages/index" */))

const emptyFn = () => {}

Vue.use(Router)

export const routerOptions = {
  mode: 'history',
  base: '/',
  linkActiveClass: 'nuxt-link-active',
  linkExactActiveClass: 'nuxt-link-exact-active',
  scrollBehavior,

  routes: [{
    path: "/dashboard",
    component: _197119df,
    name: "dashboard"
  }, {
    path: "/events",
    component: _4df0cc78,
    name: "events"
  }, {
    path: "/jobs",
    component: _085360c1,
    name: "jobs"
  }, {
    path: "/news",
    component: _3f825204,
    name: "news"
  }, {
    path: "/notice",
    component: _3e4a6cc3,
    name: "notice"
  }, {
    path: "/stories",
    component: _58f438de,
    name: "stories"
  }, {
    path: "/auth/forgot-password",
    component: _6c4e07f4,
    name: "auth-forgot-password"
  }, {
    path: "/auth/login",
    component: _c629f2ac,
    name: "auth-login"
  }, {
    path: "/auth/register",
    component: _788d99f2,
    name: "auth-register"
  }, {
    path: "/dashboard/applied-jobs",
    component: _2149ae29,
    name: "dashboard-applied-jobs"
  }, {
    path: "/dashboard/my-events",
    component: _10482232,
    name: "dashboard-my-events"
  }, {
    path: "/dashboard/my-profile",
    component: _55fab26a,
    name: "dashboard-my-profile"
  }, {
    path: "/static/About-Us",
    component: _462c57e7,
    name: "static-About-Us"
  }, {
    path: "/static/alumuni-directory",
    component: _78af4298,
    name: "static-alumuni-directory"
  }, {
    path: "/static/alumuni-general-members",
    component: _353ab2bb,
    name: "static-alumuni-general-members"
  }, {
    path: "/static/alumuni-live-members",
    component: _59b15941,
    name: "static-alumuni-live-members"
  }, {
    path: "/static/gallery",
    component: _3b18cf99,
    name: "static-gallery"
  }, {
    path: "/static/members",
    component: _0ebee5e0,
    name: "static-members"
  }, {
    path: "/static/publications",
    component: _20315ce0,
    name: "static-publications"
  }, {
    path: "/dashboard/award/create-award",
    component: _31b929fe,
    name: "dashboard-award-create-award"
  }, {
    path: "/dashboard/award/edit-award",
    component: _5c05bc62,
    name: "dashboard-award-edit-award"
  }, {
    path: "/dashboard/award/my-awards",
    component: _3500d5dc,
    name: "dashboard-award-my-awards"
  }, {
    path: "/dashboard/job/create-job",
    component: _92da3e7e,
    name: "dashboard-job-create-job"
  }, {
    path: "/dashboard/job/edit-job",
    component: _030ccb0f,
    name: "dashboard-job-edit-job"
  }, {
    path: "/dashboard/job/posted-jobs",
    component: _0cacd0c2,
    name: "dashboard-job-posted-jobs"
  }, {
    path: "/gallery/category/:id?",
    component: _fd0f8da4,
    name: "gallery-category-id"
  }, {
    path: "/news/tag/:id?",
    component: _533f4d1e,
    name: "news-tag-id"
  }, {
    path: "/auth/:__register?",
    component: _475f8023,
    name: "auth-__register"
  }, {
    path: "/events/:id",
    component: _62793d2c,
    name: "events-id"
  }, {
    path: "/jobs/:id",
    component: _4b149f69,
    name: "jobs-id"
  }, {
    path: "/news/:id",
    component: _ba1afe34,
    name: "news-id"
  }, {
    path: "/notice/:id",
    component: _0402c3eb,
    name: "notice-id"
  }, {
    path: "/page/:id?",
    component: _032446bc,
    name: "page-id"
  }, {
    path: "/stories/:id",
    component: _b9524a74,
    name: "stories-id"
  }, {
    path: "/",
    component: _33424f9a,
    name: "index"
  }],

  fallback: false
}

export function createRouter (ssrContext, config) {
  const base = (config._app && config._app.basePath) || routerOptions.base
  const router = new Router({ ...routerOptions, base  })

  // TODO: remove in Nuxt 3
  const originalPush = router.push
  router.push = function push (location, onComplete = emptyFn, onAbort) {
    return originalPush.call(this, location, onComplete, onAbort)
  }

  const resolve = router.resolve.bind(router)
  router.resolve = (to, current, append) => {
    if (typeof to === 'string') {
      to = normalizeURL(to)
    }
    return resolve(to, current, append)
  }

  return router
}
